<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_History_Controller
{
  private $user_manager;
  private $history_manager;

  function __construct()
  {
    add_action("wp_ajax_ultimate_ai_store_history", array($this, "ultimate_ai_store_history"));
    add_action("wp_ajax_ultimate_ai_update_history", array($this, "ultimate_ai_update_history"));
    add_action("wp_ajax_ultimate_ai_update_history_meta", array($this, "ultimate_ai_update_history_meta"));
    add_action("wp_ajax_ultimate_ai_switch_history_favourite", array($this, "ultimate_ai_switch_history_favourite"));
    add_action("wp_ajax_ultimate_ai_delete_history", array($this, "ultimate_ai_delete_history"));
    add_action("wp_ajax_ultimate_ai_get_user_histories", array($this, "ultimate_ai_get_user_histories"));
    add_action("wp_ajax_ultimate_ai_get_user_favourite_histories", array($this, "ultimate_ai_get_user_favourite_histories"));
    add_action("wp_ajax_ultimate_ai_store_img_tool_urls", array($this, "ultimate_ai_store_img_tool_urls"));
    add_action("wp_ajax_ultimate_ai_filter_histories", array($this, "ultimate_ai_filter_histories"));

    $this->user_manager = new Ultimate_AI_User_Manager();
    $this->history_manager = new Ultimate_AI_History_Manager();
  }

  public function send_res_wrapper($result)
  {
    if (!is_wp_error($result)) {
      $this->send_success_result(array("data" => $result));
    } else {
      $this->send_fail_result(array("data" => "fail"));
    }
  }

  public function ultimate_ai_store_history()
  {
    $this->must_fields_error(array("content", "tool_name"));
    //$content = map_deep( $_POST["content"], "sanitize_textarea_field" );
    $content = Ultimate_AI_Filter_Controller($_POST["content"]);
    $tool_name = sanitize_text_field($_POST["tool_name"]);
    $history_id = (int)sanitize_text_field($_POST["history_id"] ?? "0");
    $token = (int)sanitize_text_field($_POST["token"] ?? "0");
    $post_parent_id = (int)sanitize_text_field($_POST["post_parent_id"] ?? "0");
    $user = wp_get_current_user();

    //token != 0 then update the user token amount
    if ($token != "false" && $token > 0) {
      $token_type = $tool_name == "generate_image" ? "image" : ($tool_name == "text_to_speech" ? "tts" : "word");
      $this->user_manager->update_user_token($user, $token, $token_type, "DECREMENT");

      //post_parent_id != 0 then update the parent post total token amount and tool_uses
      if ($post_parent_id != 0) {
        $post_meta = $this->history_manager->get_history_by_id($user, $post_parent_id);
        if ($post_meta) {
          $prev_token = (int)$post_meta["total_child_token"] ?? 0;
          $new_token = $prev_token + $token;
          $this->history_manager->update_meta("total_child_token", $new_token, $post_parent_id, $user, true);
          //setting token 0 for parent post so parent also have a token on his meta
          //idealy parent dont have any token but to have consistency add 0 token 
          $this->history_manager->update_meta("token", 0, $post_parent_id, $user, true);
          $prev_tool_uses = $post_meta["tool_uses"] ?? [];
          $prev_tool_uses[$tool_name] = (int)($prev_tool_uses[$tool_name] ?? 0) + 1; //add +1 to count tool use
          $this->history_manager->update_meta("tool_uses", $prev_tool_uses, $post_parent_id, $user);
        }
      }
    }

    $result = $this->history_manager->ultimate_ai_create_new_history($user, $content, $tool_name, $history_id, $post_parent_id);

    //add token on direct meta for every tool to have consistency inside the application
    //this token will be use to generate stats and other calculation
    if ($result && $token != "false") {
      $token_type = $tool_name == "generate_image" ? "image" : "word";

      $this->history_manager->update_meta("token", $token, $result, $user, true);
      if (get_option('ultimate_ai_total_generation_' . $token_type)) {
        update_option('ultimate_ai_total_generation_' . $token_type, ((int) get_option('ultimate_ai_total_generation_' . $token_type) + (int) $token));
      } else {
        add_option('ultimate_ai_total_generation_' . $token_type, $token);
      }
    }

    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_update_history()
  {
    $this->must_fields_error(array("history_id"));
    $content = Ultimate_AI_Filter_Controller($_POST["content"]) ?? "";
    $document = Ultimate_AI_Filter_Controller($_POST["document"]) ?? "";
    $history_id = (int)sanitize_text_field($_POST["history_id"]);

    $user = wp_get_current_user();
    $value = $content ? $content : ($document ? $document : "");
    $field_name = $content ? "content" : ($document ? "document" : "");
    if (empty($value)) $this->must_fields_error(array("content", "document"));

    $result = $this->history_manager->ultimate_ai_update_history($user, $value, $history_id, $field_name);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_update_history_meta()
  {
    $this->must_fields_error(array("history_id", "key_name", "value"));
    $key_name = sanitize_key($_POST["key_name"]);
    $value = sanitize_textarea_field($_POST["value"]);
    $history_id = (int)sanitize_text_field($_POST["history_id"]);
    $is_direcet_meta = rest_sanitize_boolean($_POST["is_direcet_meta"] ?? "false");
    $user = wp_get_current_user();

    //convert boolean value to proper boolean
    $value = $value == "true" ? true : ($value == "false" ? false : $value);

    $result = $this->history_manager->update_meta($key_name, $value, $history_id, $user, $is_direcet_meta);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_store_img_tool_urls()
  {
    $this->must_fields_error(array("urls", "history_id"));
    $urls = Ultimate_AI_Filter_Controller($_POST["urls"]);
    $history_id = (int)sanitize_text_field($_POST["history_id"]);

    $user = wp_get_current_user();

    $result = $this->history_manager->ultimate_ai_store_img_tool_urls($user, $urls, $history_id);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_switch_history_favourite()
  {
    $this->must_fields_error(array("history_id", "set_manual_value", "value"));
    $history_id = (int)$_POST["history_id"];
    $set_manual_value = Ultimate_AI_Filter_Controller($_POST["set_manual_value"]) == "true" ? true : false;
    $value = Ultimate_AI_Filter_Controller($_POST["value"]) == "true" ? true : false;
    $user = wp_get_current_user();
    $result = $this->history_manager->switch_history_favourite($user, $history_id, $set_manual_value, $value);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_delete_history()
  {
    $this->must_fields_error(array("history_id"));
    $history_id = (int)$_POST["history_id"];
    $user = wp_get_current_user();
    $result = $this->history_manager->delete_history($user, $history_id);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_get_user_histories()
  {
    $this->must_fields_error(array("limit", "page"));
    $limit = (int)sanitize_text_field($_POST["limit"]);
    $page = (int)sanitize_text_field($_POST["page"]);
    $tool_name = sanitize_text_field($_POST["tool_name"] ?? "");
    $orderby = sanitize_text_field($_POST["orderby"] ?? "date");
    $post_parent_id = (int)sanitize_text_field($_POST["post_parent_id"] ?? "0");
    $user = wp_get_current_user();
    $offset = $limit * ($page - 1);
    $result = $this->history_manager->ultimate_ai_get_user_histories($user, $limit, $offset, $tool_name, $orderby, false, $post_parent_id);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_get_user_favourite_histories()
  {
    $this->must_fields_error(array("limit", "page", "tool_name"));
    $limit = (int)sanitize_text_field($_POST["limit"]);
    $page = (int)sanitize_text_field($_POST["page"]);
    $tool_name = sanitize_text_field($_POST["tool_name"]);
    $order = sanitize_text_field($_POST["order"] ?? "DESC");
    $post_parent_id = (int)sanitize_text_field($_POST["post_parent_id"] ?? "0");
    $user = wp_get_current_user();
    $offset = $limit * ($page - 1);
    $result = $this->history_manager->ultimate_ai_get_user_histories($user, $limit, $offset, $tool_name, $order, true, $post_parent_id);
    $this->send_res_wrapper($result);
  }

  public function ultimate_ai_filter_histories()
  {
    $this->must_fields_error(array("limit", "page"));
    $limit = (int)sanitize_text_field($_POST["limit"] ?? "50");
    $page = (int)sanitize_text_field($_POST["page"] ?? "1");
    $orderby = sanitize_text_field($_POST["orderby"] ?? "date");
    $offset = $limit * ($page - 1);
    $search_key_word = sanitize_text_field($_POST["search_key_word"] ?? "");
    $id = (int)sanitize_text_field($_POST["id"] ?? "0");
    //shape of meta [ ["key" => "", "value" => "", "compare" => "" ] ]
    $metas = map_deep($_POST["meta_filter"] ?? [], "sanitize_text_field");

    $user = wp_get_current_user();
    $args = ["author" => $user->ID, "posts_per_page" => $limit, "offset" => $offset];

    //search filter on prompt
    if (!empty($search_key_word)) {
      $args["meta_query"][] = ["value" => $search_key_word, "compare" => "LIKE"];
    }

    //add order filter
    $args["order"] = "DESC"; //default
    $args["orderby"] =  $orderby;

    //NEED A BETTER SOLUTION
    if ($orderby == "title") {
      $args["orderby"] = ["title" => "ASC"];
    }
    //filter by only id
    if (!empty($id)) {
      $args["p"] = $id;
    }


    //add meta filter
    foreach ($metas as $meta) {
      if (!empty($meta["key"]) && !empty($meta["value"] && !empty($meta["compare"]))) {
        $args["meta_query"][] = [
          "key" => $meta["key"],
          //if value is 1/0 then this filter is for true and false so convert that for WP_QUERY
          "value" => $meta["value"] == "1" ? true : ($meta["value"] == "0" ? false : $meta["value"]),
          "compare" => $meta["compare"]
        ];
      } elseif (!empty($meta["key"]) && $meta["key"] == "relation" && !empty($meta["value"])) {
        $args["meta_query"]["relation"] = $meta["value"];
      }
    }

    $result = $this->history_manager->ultimate_ai_filter_histories($args);
    $this->send_res_wrapper($result);
  }

  private function send_success_result($data)
  {
    wp_send_json($data, 200);
  }
  private function send_fail_result($error)
  {
    wp_send_json($error, 400);
  }

  private function must_fields_error($must_fields)
  {
    foreach ($must_fields as $field) {
      if (!$_POST[$field] || empty($_POST[$field])) {
        wp_send_json(array("data" => esc_html__("Send proper information.", ULTIMATE_AI_SLUG)), 400);
      }
    }
  }
}

new Ultimate_AI_History_Controller();
